
/* 
The first  part of this program performs the actual calculation of calibration.  
The second part of this program verifies various derivations in the text of the associated
LaTeX document.

*/


clear
#delimit ;

global filename "MicroShkQtrVsAnnStata";

* Now for the real calibration for the paper;

* Parameters are set globally in makeParameters.command, executed by ./makeParameters.command in the Calibration directory;
cd Parameters;
do varlpShkIndAnn;
do varlpShkIndAnnCS;
do varltShkIndAnn;
do varltShkIndAnnCS;

cd ..;

scalar stdlpShkAnn = varlpShkIndAnn^0.5;
scalar stdltShkAnn = varltShkIndAnn^0.5;

scalar stdlpShkAnnCS = varlpShkIndAnnCS^0.5;
scalar stdltShkAnnCS = varltShkIndAnnCS^0.5;

scalar varlpShkQtr   = varlpShkIndAnn/4;
scalar stdlpShkQtr   = varlpShkQtr^0.5;

scalar varlpShkQtrCS = varlpShkIndAnnCS/4;
scalar stdlpShkQtrCS = varlpShkQtrCS^0.5;

scalar varltShkQtr   = varltShkIndAnn*4;
scalar stdltShkQtr   = varltShkQtr^0.5;

scalar varltShkQtrCS = varltShkIndAnnCS*4;
scalar stdltShkQtrCS = varltShkQtrCS^0.5;

scalar varltShkQtrCS = varltShkIndAnnCS*4;
scalar stdltShkQtrCS = varltShkQtrCS^0.5;

set logtype text;
set linesize 255;
quietly log using $filename,replace;

display "StdDev ann perm shocks: " stdlpShkAnn ;
display "StdDev ann tran shocks: " stdltShkAnn ;

display "StdDev qtr perm shocks: " stdlpShkQtr;
display "StdDev qtr tran shocks: " stdltShkQtr;

display "Variance ann perm shocks: " varlpShkIndAnn " vs C-S Table 1 estimate " varlpShkIndAnnCS;
display "Variance ann tran shocks: " varltShkIndAnn " vs C-S Table 1 estimate " varltShkIndAnnCS;

display "Variance qtr perm shocks: " varlpShkQtr;
display "Variance qtr tran shocks: " varltShkQtr;

* display "Implied Muth parameter pi in equation pBar = pi(y_{t} + (1-pi)y_{t-1}+(1-pi)^2 y_{t-2}+...)";
* scalar pi = (varlpShkQtr/(varlpShkQtr+varltShkQtr));
* display  "pi = " pi;

display "\\begin{tabular}{llcccc} % This table is generated by running the Stata program MicroShkQtrVsAnnStata.do ";
display "     \\multicolumn{2}{l}{Source}      & \$\\sigma^{2}_{\\vec{\\psi}}$ & \$\\sigma^{2}_{\\vec{\\theta}}$ & \$\\sigma_{\\vec{\\psi}}$ & \$\\sigma_{\\vec{\\theta}}$ ";
display "\\\\ \\hline \\multicolumn{2}{l}{Annual}";
display "\\\\ & C-S Table 1 & " %05.4f varlpShkIndAnnCS      " & " %05.4f varltShkIndAnnCS        " & " %05.4f stdlpShkAnnCS        " & " %05.4f stdlpShkAnnCS;
display "\\\\ & This Paper  & " %05.4f varlpShkIndAnn        " & " %05.4f varltShkIndAnn          " & " %05.4f stdlpShkAnn          " & " %05.4f stdltShkAnn;
display "\\\\ \\multicolumn{2}{l}{Quarterly}";
display "\\\\ & C-S Table 1 & " %05.4f varlpShkQtrCS      " & " %05.4f varltShkQtrCS        " & " %05.4f stdlpShkQtrCS        " & " %05.4f stdlpShkQtrCS;
display "\\\\ & This Paper  & " %05.4f varlpShkQtr        " & " %05.4f varltShkQtr          " & " %05.4f stdlpShkQtr          " & " %05.4f stdltShkQtr;
display "\\\\ \hline ";
* display "\\\\ \multicolumn{6}{l}{\$\\pi = \\sigma^{2}_{\\psi}/(\\sigma^{2}_{\\psi}+\\sigma^{2}_{\\theta})\$ = " varlpShkQtr/(varlpShkQtr+varltShkQtr) "}";
display "\\end{tabular}";

quietly log close;

* Produce LaTeX output file $\filename.out;
shell tr '\015' '\012' < $filename.log > $filename.txt;
shell fgrep \\\\ $filename.txt | grep -v display  | grep -v global | grep -v mac> $filename.out;
shell rm $filename.log $filename.txt;
shell cat $filename.out;

* Verify calculations in MicroShkQtrVsAnn.tex;

set obs 10000;

gen time = _n;
tsset time;

scalar  multShkAnn = -varltShkIndAnn/2;
scalar  multShkQtr = -varltShkQtr/2;

gen tShkQtr = exp(multShkQtr+stdltShkQtr*invnorm(uniform()));
gen tLevQtr = tShkQtr;
gen tDevQtr = tShkQtr-1;
gen ltShkQtr = log(tShkQtr);

summ ltShkQtr;
scalar varltShkQtrEst = r(Var);
summ tDevQtr;
scalar varltDevQtrEst = r(Var);

display "Test: var(log(tShkQtr))=var(tDevQtr)";
display varltShkQtrEst " = " varltDevQtrEst " = " varltShkQtr;

gen  tShkAnn = 1+(tDevQtr[_n]+tDevQtr[_n+1]+tDevQtr[_n+2]+tDevQtr[_n+3])/4;
gen ltShkAnn = log(tShkAnn);

gen  tDevAnn = tShkAnn-1;

summ ltShkAnn;
scalar varltShkIndAnnEst=r(Var);

summ tDevAnn;
scalar varltDevAnnEst=r(Var);

display "Test: var(log(tShkAnn))=var(tDevAnn)=varltShkIndAnn";
display varltShkIndAnnEst "=" varltDevAnnEst "=" varltShkIndAnn;

* Now Permanent  shocks;
scalar  mulpShkQtr = -varlpShkQtr/2;

gen pShkQtr = exp(mulpShkQtr+stdlpShkQtr*invnorm(uniform()));
gen    lpShkQtr = log(pShkQtr);
summ   lpShkQtr;
scalar varlpShkQtrEst = r(Var);

gen    pDevQtr = pShkQtr-1;
summ   pDevQtr;
scalar  varpDevQtrEst = r(Var);

display "Test: var(log(pShkQtr)) = var(pDevQtr) = varlpQtrLev";
display varlpShkQtrEst "=" varpDevQtrEst "=" varlpShkQtr;

gen     pLevQtr = 1;
replace pLevQtr = pShkQtr*l.pLevQtr if time>1;

gen     pLevAnn = pLevQtr[_n]+pLevQtr[_n+1]+pLevQtr[_n+2]+pLevQtr[_n+3];
gen     pShkAnn = pLevAnn[_n]/pLevAnn[_n-4];
gen    lpShkAnn  = log(pShkAnn);
gen    lpShkAnnM1= l4.lpShkAnn;
gen    lpShkAnnM2= l8.lpShkAnn;

gen    pGroAnn    = pLevAnn[_n]/pLevAnn[_n-4];
gen    pGroAnn2Yr = pLevAnn[_n]/pLevAnn[_n-8];

gen   lpGroAnn    = log(pGroAnn);
gen   lpGroAnn2Yr = log(pGroAnn2Yr);

summ lpGroAnn;
scalar varlpGroAnnEst = r(Var);
summ lpGroAnn2Yr;
scalar varlpGroAnn2YrEst = r(Var);

disp "var(lpGroAnn2Yr)-var(lpGroAnn) = 4 varlpShkQtr";
disp varlpGroAnn2YrEst-varlpGroAnnEst " = " 4*varlpShkQtr;

